<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI Solutions
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI Solutions
// Copyright VIAVI Solutions 2017. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\services\SMTIService;
use app\services\SMTService;
use app\serviceshelper\media\SMTMediaException;
use app\serviceshelper\media\SMTServer;

/**
 * Service to setup the OTU Onmsi Server features and display its configuration.
 * 
 * @author Sylvain Desplat
 */
class SMTOnmsiServerService extends SMTService implements SMTIService
{    
    /**
     * Fetch ONMSi servers configuration
     *
     * @url GET
     * 
     * @access protected
     * @class SMTAccessControl {@requires user}
     */
    function fetchOnmsiServer()    
    {        
        $serverListDto = new SMTOnmsiServerListDto();
        $server = new SMTServer();
        $server->setContext( $this->getContext() );
        
        try
        {
            $serverListDto = $server->retrieveServerConf();      	        
    	}
    	catch ( \Exception $e )
    	{
    	    $this->handleException($e);
    	}
    
    	return $serverListDto->getJsonData();
    }    
    
    /**
     * Perform a Test of ONMSi media: test communication and send an alarm
     *
     * @url POST /test/
     * @access protected
     * @class SMTAccessControl {@requires user}
     */
    function testOnmsi( $request_data )
    {
        try 
        {
            $server = new SMTServer();
            $server->setContext( $this->getContext() );
            $serverDto= SMTOnmsiServerDto::getInstance( $request_data );
            
            $server->testONMSiConnection($serverDto);
    	}
    	catch ( \Exception $e )
    	{
    	    $this->getContext()->traceException($e);
    		if ( !( $e instanceof SMTMediaException ) )
    	    {
    	        $e = new SMTMediaException( SMTMediaException::ERROR_INVALID_CONFIG );
    	    }    		   
    		$this->handleException($e);
    	}    			
    	return self::RESULT_OK;
    }
}

?>