<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\serviceshelper\otau\SMTSwitchManager;

use app\settings\SMTSmartOtuSettings;

use app\sharedmemory\SMTMemoryManager;

use app\view\SMTTestRestApiPage;
use app\services\SMTIService;
use app\services\SMTService;
use app\services\security\SMTAccessControl;
use app\parser\SMTOtuApi;
use app\serviceshelper\module\SMTModule;

/**
 * Service to setup the OTU module features and display its configuration.
 * 
 * @author Sylvain Desplat
 */
class SMTModuleService extends SMTService implements SMTIService
{ 
    /**
     *
     * @url POST
     * 
     * @access protected
     * @class SMTAccessControl {@requires install}
     */
    function updateOTDRModule()
    {
        try
        {
            if ( SMTSwitchManager::isDtssSwitchInCalibOrInDet($this->getContext()->getOtuSocket()) )
            {
                $this->send( SMTOtuApi::CMD_config );
                // in the special case of dtss module, we apply also the switch detected
                SMTSwitchManager::applySwitchDetected($this->getContext()->getOtuSocket());
            }
            else
            {
        	    $this->send( SMTOtuApi::CMD_config );
            }        	
        	
        	
        	SMTMemoryManager::deleteAll( SMTModuleDto::getClass() );	
        }
        catch ( \Exception $e )
        {
        	$this->handleException($e);
        }
    }        
    
    /**
     *
     * @url GET
     * 
     * @access protected
     * @class SMTAccessControl {@requires user}
     */
    function fetchModule()
    {
    	try
    	{
    	    $module = new SMTModule();
    	    $module->setContext( $this->getContext() );    	    
    	    $configDetectModuleDto = $module->fetchModules();    	   
    	}
    	catch ( \Exception $e )
    	{
    		$this->handleException($e);
    	}
    
    	return $configDetectModuleDto->getJsonData();
    }
    
    /**
     * Retrieve OTDR functions and their wavelengths,pulses,ranges,resolutions
     *
     * @url GET /functions
     *
     * @access protected
     * @class SMTAccessControl {@requires user}
    
     */
    function getOtdrModuleFunctions()
    {        
        try
        {
        	$module = new SMTModule();
        	$module->setContext( $this->getContext() );
        	$moduleDto = $module->fetchOtdrModuleFunctions();
        }
        catch ( \Exception $e )
        {
        	$this->handleException($e);
        }
        
        return $moduleDto->getJsonData();
    }
    
    
    /**
     * @url GET /test/updatemodule
     */
    function testUpdateModule()
    {    
        if ( SMTSmartOtuSettings::isDebugMode() )
        {
        	$url = '/module';
        	$page = new SMTTestRestApiPage($url, "", 'POST');
        	$this->getContext()->getHttpResponse()->send( $page );
        }
    }    
    
}

?>