<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\util\SMTInvalidValueException;
use app\util\SMTRwDto;
use app\util\SMTUtil;
use app\serviceshelper\media\SMTEmail;

class SMTConfEmailDto extends SMTRwDto
{
    /**
     * @SMTAttributeInfosAnnotation(classname='app\services\setup\SMTEmailDto',islist='true')
     * @var array app\services\setup\SMTEmailDto
     */
    protected $emails = array();
    
	protected $smtpServer = "";
    
    protected $smtpPort = SMTEmail::DEFAULT_SMTP_PORT_NOT_SET;
    
    protected $smtpSecurityProtocol = SMTEmail::DEFAULT_SMTP_SECURITY_NONE;
	
	protected $login = "";
	
	protected $password ="";
	
	protected $active = FALSE;
	
	/**
	 * Whether files (OTDR traces) must be attached to Emails
	 *
	 * @var integer
	 */
	protected $attachFile = FALSE;

	/**
	 * @param boolean
	 */
	public function setActive( $active )
	{		
		$this->active = $active;
	}
	
	/**
	 * @return boolean
	 */
	public function isActive()
	{
		return $this->active;
	}	
	
	/**
	 * @param boolean
	 */
	public function setAttachFile( $attachFile )
	{
		$this->attachFile = $attachFile;
	}
	
	/**
	 * @return boolean
	 */
	public function isAttachFile()
	{
		return $this->attachFile;
	}
	
	/**
	 * @param string
	 */
	public function setSmtpServer( $smtpServer )
	{
		$this->smtpServer = $smtpServer;
	}

	/**
	 * @return string
	 */
	public function getSmtpServer()
	{
		return $this->smtpServer;
	}

	/**
	 * @param int
	 */
	public function setSmtpPort( $smtpPort )
	{
        if ( !isset($smtpPort) || $smtpPort === NULL || !SMTUtil::isInt( $smtpPort ) || $smtpPort < 0 )
        {
        	throw new SMTInvalidValueException( SMTInvalidValueException::INVALID_VALUE, NULL, "smtpPort", $smtpPort );
        }    
    	$this->smtpPort = SMTUtil::convertToInt( $smtpPort );    
	}

	/**
	 * @return int
	 */
	public function getSmtpPort()
	{
		return $this->smtpPort;
	}
    
	/**
	 * @param string
	 */
	public function setSmtpSecurityProtocol( $smtpSecurityProtocol )
	{
		if ( !isset($smtpSecurityProtocol) || ($smtpSecurityProtocol === NULL) || (!SMTEmail::isEmailSMTPSecurityProtocolValid($smtpSecurityProtocol) ))
		{
			throw new SMTInvalidValueException( SMTInvalidValueException::INVALID_VALUE, NULL, "smtpSecurityProtocol", $smtpSecurityProtocol );
		}
		$this->smtpSecurityProtocol = $smtpSecurityProtocol;
	}
	
	/**
	 * @return string
	 */
	public function getSmtpSecurityProtocol()
	{
		return $this->smtpSecurityProtocol;
	}	
	
	/**
	 * @param string
	 */
	public function setLogin( $login )
	{
		$this->login = $login;
	}

	/**
	 * @return string
	 */
	public function getLogin()
	{
		return $this->login;
	}

	/**
	 * @param string
	 */
	public function setPassword( $password )
	{
		$this->password = $password;
	}

	/**
	 * @return string
	 */
	public function getPassword()
	{
		return $this->password;
	}

	/**
	 * @param array
	 */
	public function setEmails( $emails )
	{
		$this->emails = $emails;
	}

	/**
	 * @return array
	 */
	public function getEmails()
	{
		return $this->emails;
	}
	
	/**
	 * @param app\services\setup\SMTEmailDto
	 */
	public function addEmail( SMTEmailDto $email )
	{
		array_push( $this->emails, $email );
	}	

	/**
	 * Test whether email media is active on OTU
	 *
	 * @return boolean
	 */
	public function isEmailActive()
	{
		return $this->isActive() && (count( $this->emails ) > 0);
	}
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}

	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}

	/**
	 * Create the Dto from a Json Dto in an array
	 *
	 * @param array $json_array json data in an array
	 *
	 * @return \app\services\setup\SMTConfEmailDto
	 */
	static function getInstance( array &$json_array )
	{
		return self::forge( get_class(), $json_array );
	}
}


?>