<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services;

use app\http\SMTHttpResponse;
use app\http\SMTContext;

/**
 * Base class for services
 * 
 * @author Sylvain Desplat
 *
 */
abstract class SMTService implements SMTIService
{
    /**
     * Service processing successful
     * 
     * @var string
     */
    const RESULT_OK = "OK";
    /**
     * Service processing failure
     *
     * @var string
     */
    const RESULT_KO = "KO";
    
    /**
     * Retrieve application context in services
     *
     * @return \app\http\SMTContext
     */
    function getContext()
    {
    	//SMTRestlerRouter injected by framework, shouldn't be NULL
    	return SMTContext::getContext( $this->restler );
    }
    
    /**
     * Shortcut to send socket command and receive result
     *
     * @param $command the command to execute on OTU.
     *
     * @return the result of the command.
     */
    function sendReceive( $command )
    {
    	return $this->getContext()->getOtuSocket()->sendReceive( $command );
    }    
    
    /**
     * Shortcut to send receive socket command
     *
     * @param $command the command to execute on OTU.
     */
    function send( $command )
    {
    	$this->getContext()->getOtuSocket()->send( $command );
    }    
    
    /**
     * Handle application exception:<br>
     *  - notify the exception to the HttpResponse object
     *  
     * @param \Exception $e
     */
    function handleException( \Exception $e )
    {
        $this->getContext()->getLogger()->traceException( $e );
        SMTHttpResponse::handleException( $e, $this->getContext() );        
    }
}


?>