<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\otuMediation;

use app\events\operations\SMTOperationEventDto;

/**
 * Otu Operation event codes
 * 
 * @author Sylvain Desplat
 *
 */
class SMTOtuOperationStatus
{       
    const INIT = "INIT";
    const WAITING = "WAITING";    
    const IN_PROGRESS = "IN_PROGRESS";
    const AVAILABLE = "AVAILABLE";
    const ENDED = "ENDED";
    const INVALID_STATUS = "INVALID_STATUS";
    const NO_PROGRAMMED = "NO_PROGRAMMED";
    const FAILED = "FAILED";    
    const BAD_TIMESLOT = "BADTIMESLOT";        
       
    /**
     * Whether the status is in waiting, init or in_progress
     *
     * @param string $otuCode operation status
     *
     * @return boolean
     */
    public static function isOperationRunning( $otuCode )
    {
    	$running = FALSE;
    	switch( $otuCode )
    	{
    		case self::INIT:
    		case self::IN_PROGRESS:
    		case self::WAITING:
    			$running = TRUE;
    			break;
    
    		default:
    			$running = FALSE;
    			break;
    	}
    	return $running;
    }    
    
    /**
     * Whether the status given is an operation status
     * 
     * @param string $otuCode operation status
     * 
     * @return boolean
     */
    public static function isValidOperationStatus( $otuCode )
    {
        $valid = FALSE;
        switch( $otuCode )
        {
        	case self::INIT:
        	case self::IN_PROGRESS:
        	case self::AVAILABLE:
        	case self::WAITING:
        	case self::ENDED:
        	case self::INVALID_STATUS:
        	case self::NO_PROGRAMMED:
        	case self::BAD_TIMESLOT:
        	case self::FAILED:
        		$valid = TRUE;
        		break;
        
        	default:
        	    $valid = FALSE;
        		break;
        }
        return $valid;
    }           
    
    /**
     * Translates status code. If the code is not found, returns an empty string.
     *
     * @param string $otuCode The status code to translate
     *
     * @return string the dto status code 
     */
    public static function decodeOtuStatus( $otuCode )
    {
    	$code = MSG_INVALID_STATUS.$otuCode;
    
    	switch( $otuCode )
    	{
    	    case self::INIT:
    	    	$code = SMTOperationEventDto::INIT;
    	    	break;
    	    case self::IN_PROGRESS:
    	    	$code = SMTOperationEventDto::IN_PROGRESS;
    	    	break;
    	    case self::WAITING:
    	    	$code = SMTOperationEventDto::WAITING;
    	    	break;
    	    case self::AVAILABLE:
    	    case self::ENDED:
    	    	$code = SMTOperationEventDto::AVAILABLE;
    	    	break;    	    
    		case self::INVALID_STATUS:
    			$code = SMTOperationEventDto::INVALID_STATUS;
    			break;
			case self::BAD_TIMESLOT:
				$code = SMTOperationEventDto::BAD_TIMESLOT;
				break;
			case self::NO_PROGRAMMED:
				$code = SMTOperationEventDto::NO_PROGRAMMED;
				break;
			case self::FAILED:
				$code = SMTOperationEventDto::FAILED;
				break;    						    			
    		default:
    			break;
    	}
    	return $code;
    }        
}

?>