try:
    from c_struct import read_struct_from_file, write_struct_to_file
    from calib_type import CommonHeader
except ImportError:
    from .c_struct import read_struct_from_file, write_struct_to_file
    from .calib_type import CommonHeader
from jdsu.mts.blockutils import mount_cal, umount_cal
import datetime, os

PLATFORM_MTS4000NG = {
    "Common": {
        "First": {
            "Section_Name": "common",
            "Section_Version": 101
        },
        "Header": {
            "Header_Identity": 32,
            "Module_Design": 19,
            "Cfg_File": "d.base4k",
            "Module_Name": "MTS 4000 V2",
            "Prefix": "EBAH",
        }
    },
    "Prod": {
        "First": {
            "Section_Name": "prod",
            "Section_Version": 101,
            "Is_Last_Section": True
        }
    }
}

PLATFORMS = {
    "Mts4000Ng": PLATFORM_MTS4000NG
}


def cal_init_platform(cal):
    with open("/etc/platform.conf", "r") as pl:
        for line in pl:
            if "CFG_PLATFORM_NAME" in line:
                platform_name = line.split("=")[1].strip().strip("\"")
                platform_conf = PLATFORMS[platform_name]
                cal.init(platform_conf)
    cal_set_header(cal, "Date_Fab", datetime.datetime.today())


def cal_set_header(cal, field, serial):
    cal.data["Common"].set(field, serial)


def cal_get_base_calibration():
    import os.path
    calmount = False
    try:
        calmount = mount_cal()
    except:
        pass

    if os.path.exists("/cal/board_info.bin"):
        cal = read_struct_from_file("/cal/board_info.bin", CommonHeader)
    else:
        cal = CommonHeader()

    try:
        umount_cal(calmount)
    except:
        return False

    return cal


def cal_set_base_calibration(cal):
    try:
        calmount = mount_cal()
        cal_set_header(cal, "Date_Calib", datetime.datetime.today())
        write_struct_to_file("/cal/board_info.bin", cal)
        umount_cal(calmount)
        return True
    except Exception as err:
        print("# %s"%err)
        print("FAIL")
    return False


if __name__ == "__main__":
    cal = cal_get_base_calibration()
    cal_init_platform(cal)
    cal_set_header(cal, "Serial_Number", "00026")
    cal_set_header(cal, "Soft_Fab_Release", 9999)
    cal_set_header(cal, "Soft_Fab_Release", 9999)
    cal_set_header(cal, "Calibrated", True)
    cal_set_header(cal, "Date_Fab", datetime.datetime(2017, 8, 30, 10, 59, 19))
    cal_set_header(cal, "Date_Calib", datetime.datetime(2017, 9, 11, 17, 50, 13))
    print(cal)
    write_struct_to_file("board_info_saved.bin", cal)
