import subprocess

class Bootenv(object):
    def __init__(self):
        self.__dict__['__vars'] = dict()
        self.refresh()

    def refresh(self):
        env = subprocess.check_output(["fw_printenv"])
        for line in env.decode('ascii').split("\n"):
            envs = line.strip().split("=")
            if len(envs) >= 2:
                self.__dict__['__vars'][envs[0]] = "=".join(envs[1:])

    def keys(self):
        return self.__dict__['__vars'].keys()

    def __getattr__(self, attr):
        var = self.__dict__['__vars']
        if attr in var.keys():
            return var[attr]
        else:
            return ""

    def __setattr__(self, k, v):
        var = self.__dict__['__vars']
        var[k] = v
        subprocess.check_output(["fw_setenv", str(k), str(v)])

bootenv = Bootenv()
