import QtQuick 1.1
import "Viavi_Colors.js" as VColor

Rectangle {
    id: container

//   width: 740
	width: 540
    height: 100

    border.width: 3
    border.color: VColor.cViaviColorGray
    color: VColor.cViaviColorLightGray1
    
    property bool validationIsPossible: false
    
    property int buttonWidth: 160
    property int buttonHeight: 80
    property int textSize: 20
       
    Row
    {
    	anchors.centerIn: parent
	    spacing: 10
    
	    Rectangle {
	        id: exitButton
	        width: buttonWidth
	        height: buttonHeight
	        radius: 5
	        color: VColor.cViaviColorGray
	        anchors.verticalCenter: parent.verticalCenter
	        anchors.leftMargin: 20
	
	        Text {
	            color: VColor.cViaviColorWhite
	            anchors.fill: parent
	            text: windows_manager.txtExitRecording
	            horizontalAlignment: Text.AlignHCenter
	            verticalAlignment:  Text.AlignVCenter
	            font.pixelSize: textSize
	        }
	
	        MouseArea {
	            anchors.fill: parent
	            onClicked: {
	                windows_manager.Close_Recording_Information_Windows();
	            }
	        }
	    }
	
	    Rectangle {
	        id: fileOnlyButton
	        width: buttonWidth
	        height: buttonHeight
	        radius: 5
	        color: VColor.cViaviColorLightBlue
	        anchors.verticalCenter: parent.verticalCenter
	        
	        enabled: validationIsPossible
	        opacity: validationIsPossible ? 1 : 0.4
	        
	        Text {
	            color: VColor.cViaviColorWhite
	            anchors.fill: parent
	            text: windows_manager.txtFileOnly
	            horizontalAlignment: Text.AlignHCenter
	            verticalAlignment:  Text.AlignVCenter
	            font.pixelSize: textSize
	        }
	
	        MouseArea {
	            anchors.fill: parent
	            onClicked: {
	            if ( validationIsPossible != false )
	               {
	               recording_information_data.Wizard_Save_Acquisition(false);
	               windows_manager.Close_Recording_Information_Windows();
	               }
	            else
	               {
	               console.log("Empty or invalid field");
	               }
	            }
	        }
	    }
	    
	    Rectangle {
	        id: filePdfButton
	        width: buttonWidth
	        height: buttonHeight
	        radius: 5
	        color: VColor.cViaviColorLogoPurple
	
	        anchors.verticalCenter: parent.verticalCenter
	        
	        enabled: validationIsPossible
	        opacity: validationIsPossible ? 1 : 0.4
	        
	        Text {
	            color: VColor.cViaviColorWhite
	            anchors.fill: parent
	            text: windows_manager.txtFilePdf
	            horizontalAlignment: Text.AlignHCenter
	            verticalAlignment:  Text.AlignVCenter
	            font.pixelSize: textSize
	        }
	
	        MouseArea {
	            anchors.fill: parent
	            onClicked: {
	            if ( validationIsPossible != false )
	               {
	               recording_information_data.Wizard_Save_Acquisition(true);
	               windows_manager.Close_Recording_Information_Windows();
	               }
	            else
	               {
	               console.log("Empty or invalid field");
	               }
	            }
	        }
	    }
    }    
}
