import QtQuick 1.1
import "Viavi_Colors.js" as VColor

Rectangle {
    id: keyViewPopup
    color: VColor.cViaviColorLogoPurple
    //color: VColor.cViaviColorLightBlue

    focus: true

    // TBD - Animate appearance of the pop-up
    //Behavior on height { PropertyAnimation { duration: 300 } } //easing.type: Easing.OutElastic;

    //property int heightButton: keyViewPopup.height / 5 - 8
    //property int heightButton: 78
    property int heightButton: (keyViewPopup.height - 8) / 3


    MouseArea {
        anchors.fill: parent
        onClicked: {
            View_Popup.close_Popup();
            }
        }

    Column {
        id: isu_Popup_Col
        spacing: 0
        anchors.left: parent.left
        anchors.leftMargin: 3
        anchors.top: parent.top
        anchors.topMargin: 3

        width: parent.width - 15

        Rectangle {
            id: isuFile

            width: parent.width
            height: heightButton
            color: mouse_Area_File.containsMouse ?  VColor.cViaviColorLightBlue : VColor.cViaviColorGray //"transparent"

            anchors.horizontalCenter: parent.horizontalCenter

            Image { // The icon metaphor
                id: fileMetaphor
                
                anchors.bottom: parent.bottom
                anchors.bottomMargin: 12
                anchors.horizontalCenter: parent.horizontalCenter
                height: 32
                fillMode: Image.PreserveAspectFit
                
                source:"/acterna/storage/look-and-feel/generic/icon_popup_view_file.png"
                }
                
            Text {
                id: fileTitle
                anchors.top: parent.top
                anchors.topMargin: 12
                anchors.horizontalCenter: parent.horizontalCenter

                color: VColor.cViaviColorWhite
                text: qsTr("File")
                font.bold: true
                font.pointSize: 11
                horizontalAlignment: Text.AlignHCenter
                }
                
            MouseArea {
                id: mouse_Area_File
                anchors.fill: parent
                onClicked: { View_Popup.keyFile(); }
                }
            }
            
        Rectangle { // Separator
            color: VColor.cViaviColorLightBlue
           
            anchors.horizontalCenter: parent.horizontalCenter
           
            width: parent.width - 10
            height: 1
            }

        Rectangle {
            id: isuSetup
            
            width: parent.width
            height: heightButton
            color: mouse_Area_Setup.containsMouse ? VColor.cViaviColorLightBlue : VColor.cViaviColorGray
            anchors.horizontalCenter: parent.horizontalCenter
            
            Image { // The icon metaphor
                id: setupMetaphor
                
                anchors.bottom: parent.bottom
                anchors.bottomMargin: 12
                anchors.horizontalCenter: parent.horizontalCenter
                
                height: 32
                fillMode: Image.PreserveAspectFit
                
                source:"/acterna/storage/look-and-feel/generic/icon_popup_view_setup.png"
                }
                
            Text {
                id: setupTitle
                
                anchors.top: parent.top
                anchors.topMargin: 12
                anchors.fill: parent
                
                color: VColor.cViaviColorWhite
                text: qsTr("Setup")
                font.bold: true
                font.pointSize: 11
                horizontalAlignment: Text.AlignHCenter
                }
                
            MouseArea {
                id: mouse_Area_Setup
                anchors.fill: parent
                onClicked: { View_Popup.keySetup(); }
                }
            }
            
       Rectangle { // Separator
            color: VColor.cViaviColorLightBlue
           
            anchors.horizontalCenter: parent.horizontalCenter
           
            width: parent.width - 10
            height: 1
            }

        Rectangle {
            id: isuResults
            
            width: parent.width
            height: heightButton
            color: mouse_Area_Results.containsMouse ? VColor.cViaviColorLightBlue : VColor.cViaviColorGray
            anchors.horizontalCenter: parent.horizontalCenter

            Image { // The icon metaphor
                id: resultsMetaphor
                
                anchors.bottom: parent.bottom
                anchors.bottomMargin: 12
                anchors.horizontalCenter: parent.horizontalCenter
                height: 32
                fillMode: Image.PreserveAspectFit
                source:"/acterna/storage/look-and-feel/generic/icon_popup_view_results.png"
                }
                
            Text {
                id: resultsTitle
                
                anchors.top: parent.top
                anchors.topMargin: 12
                anchors.horizontalCenter: parent.horizontalCenter
                
                color: VColor.cViaviColorWhite
                text: qsTr("Results")
                font.bold: true
                font.pointSize: 11
                horizontalAlignment: Text.AlignHCenter
                }
                
            MouseArea {
                id: mouse_Area_Results
                anchors.fill: parent
                onClicked: { View_Popup.keyResults(); }
                }
            }
            
//       Rectangle { // Separator
//           color: VColor.cViaviColorLightBlue
//           
//           anchors.horizontalCenter: parent.horizontalCenter
//           
//           width: parent.width - 10
//           height: 1
//        }
        
        } //end of Results / Setup / File column

    } // end Rectangle

