<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\view;

use app\admin\SMTLanguage;
use app\admin\SMTOtuMode;
use app\http\SMTContext;

/**
 * Generates an html test page;
 *
 * @author Sylvain Desplat
 */
class SMTAppPage implements SMTIPage
{
	const APP_FILE = "app/view/SMTAppLayout.php";

	/**
	 *
	 * @var string
	 */
	private $htmlFile;

	/**
	 *
	 * @var app\http\SMTContext
	 */
	private $context;

	/**
	 * Host page: display GWT host page
	 *
	 * @param SMTContext $context
	 */
	function __construct( $context )
	{
		$this->htmlFile = self::APP_FILE;
		$this->context = $context;
	}

	/**
	 * Generate the GWT host page
	 *
     * @return page generation status
	 */
	function generatePage()
	{	  
		//retrieve variables used in htmlFile
		$currentLanguage = SMTLanguage::getCurrentLanguage();
		$smartMode       = SMTOtuMode::getOtuMode();
		$smartModeLogo   = SMTOtuMode::getOtuModeLogo();
		$productName     = SMTOtuMode::getOtuModeDisplay();
		$smartModeDisplay= SMTOtuMode::getOtuModeDisplay();
		
		//populate the layout page
		require $this->htmlFile;
	}
}
?>