<?php
namespace app\util\upload;

use app\serviceshelper\maintenance\SMTCertificate;

require_once('SMTUpload.php');

use app\util\SMTLogger;
use app\services\maintenance\SMTUploadStatusDto;
use app\util\upload\SMTUploadStatus;
use app\util\SMTUtil;

/**
 * Begining of upload script
 * 
 */
//2mn script timeout
set_time_limit(120);

$noUploadRunning = SMTUploadStatus::checkNoUploadRunning();

if ( $noUploadRunning == TRUE )
{
    $uploadStatus = upload_file( SMTUtil::SMARTOTU_TEMP_DIR );

    
    if ( $uploadStatus->getUploadErrorStatus() == SMTUploadStatusDto::NO_ERROR )
    {
        SMTLogger::getInstance()->trace( sprintf("Upload of certificate %s complete...", $uploadStatus->getFileName()), SMTLogger::PINFO);

        $certificateType = isset($_POST["certificate_type"]) ? $_POST["certificate_type"] : null;
        //copy certificate to its target directory
        try 
        {
            SMTCertificate::copySslCertificate($uploadStatus->getFileName(), $certificateType);
        }
        catch ( \Exception $e )
        {
            $uploadStatus->setUploadErrorStatus( SMTUploadStatusDto::COPY_FAILED );
            $uploadStatus->setProgress( SMTUploadStatusDto::NO_UPLOAD );
        }
    }
}
else
{
    $uploadStatus = new SMTUploadStatusDto();
    $uploadStatus->setProgress( SMTUploadStatusDto::NO_UPLOAD );
    $uploadStatus->setUploadErrorStatus( SMTUploadStatusDto::UPLOAD_ALREADY_RUNNING );
    SMTLogger::getInstance()->trace("Upload already running...", SMTLogger::ERROR);
}

$response = buildJsonResponse( $uploadStatus );

die( $response );

?>