<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI
// Copyright JDSU 2016. All rights reserved.
// *********************************************************
namespace app\serviceshelper\sensing;

use app\util\SMTDto;

/**
 * 
 * @author Sylvain Desplat
 *
 */
class SMTDTSSFunctionDto extends SMTDto
{
    /**
     * @var string
     */
    protected $name;
        
    /**
     * @param string $name
     */
    public function setName( $name )
    {
        $this->name = $name;
    }
    
    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}

	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
	
	/**
	 * Returns the dto class name.
	 *
	 * @return the dto class name.
	 */
	public static function getClass()
	{
		return __CLASS__;
	}	
}
?>