<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from Viavi Solutions 
// Copyright JDSU 2016. All rights reserved.
// *********************************************************
namespace app\serviceshelper\media;

use app\util\SMTLogger;

/**
 * Port filter buffer encoder/decoder used for emails filtering by optical switch port
 * 
 * @author Sylvain Desplat
 */
class SMTEmailPortFilterEncoderDecoder
{    
    const NB_MAX_DIGIT_BUFFER = 256;
    const EMPTY_EMAIL = "#0";
       
    /**
     * Build the OTU port buffer string from the given port array of the selected port to send email
     * Used for SmartOTU
     *
     * @param array  $portArray
     * @param number $portCount
     * 
     * @return string
     */
    static function encodePortFilter( $portArray, $portCount )
    {
        if ( $portCount <=0 )
        {
            return self::EMPTY_EMAIL;
        }
        
        $bufferBin = array_fill(0, $portCount, 0);
        
		foreach ( $portArray as $port )
		{
		    $bufferBin[$port - 1] = 1;
		}
				
		$string_buffer_tmp = implode($bufferBin);
		SMTLogger::getInstance()->trace( "string_buffer_tmp: ".$string_buffer_tmp, SMTLogger::DEBUG );
		$string_buffer_tmp_hex = self::binarraytohex($string_buffer_tmp);
		//if length is odd, append 0
		if( strlen($string_buffer_tmp_hex) & 1 )
		{
		    $string_buffer_tmp_hex = $string_buffer_tmp_hex."0";
		}
		
		SMTLogger::getInstance()->trace( "string_buffer_tmp_hex: ".$string_buffer_tmp_hex, SMTLogger::DEBUG );
		$buf_len = strlen($string_buffer_tmp_hex);
		$info_len = strlen($buf_len);
		$portBuffer = "#".$info_len.$buf_len.$string_buffer_tmp_hex;
		
		SMTLogger::getInstance()->trace( "portBuffer: ".$portBuffer, SMTLogger::DEBUG );

		return $portBuffer;
    }    
    
    /**
     * Retrieve port selected to send email for the given OTU port buffer
     * 
     * @param string $portBuffer
     * @param number $portCount
     */
    static function decodePortFilter( $portBuffer, $portCount )
    {        
        $portArray = array();
        
        $info_len = substr($portBuffer, 1, 1);
        //if there is a port
        if ( $info_len > 0 )
        {
            $buf_len = substr( $portBuffer, 2, $info_len);
            $buffer_tmp_hex = substr($portBuffer, -($buf_len), $buf_len);
            SMTLogger::getInstance()->trace( "buffer_tmp_hex: ".$buffer_tmp_hex, SMTLogger::DEBUG );
            $buffer_tmp_bin = self::hextobinarray($buffer_tmp_hex);            
            SMTLogger::getInstance()->trace( "buffer_tmp_bin: ".$buffer_tmp_bin, SMTLogger::DEBUG );
            //limit the buffer to the size of the switch
            $buffer_tmp_bin = substr($buffer_tmp_bin, 0, $portCount);
            SMTLogger::getInstance()->trace( "buffer_tmp_bin: ".$buffer_tmp_bin, SMTLogger::DEBUG );
            $portArray_tmp = str_split($buffer_tmp_bin, 1);
            foreach ($portArray_tmp as $key=>$value)
            {
                if ( $value == 1 )
                {
                    array_push( $portArray, $key + 1);
                }   
            }
        }
        return $portArray;
    }

/**
 * Convert an hexa string into a binary string, byte by byte
 * Hexa string is converted every 2 hexa characters (byte) as below:
 * hexa: 10 -> bin: 00010000 revert-> 00001000 : port 5 selected
 *
 * @param string $hex
 * @return string
 */
private static function hextobinarray($hex)
{
	$n = strlen($hex);
	$sbin="";
	$i=0;
	while($i<$n)
	{
		$tmp_hex =substr($hex,$i,2);
		$tmp_bin = base_convert($tmp_hex, 16, 2);
		$tmp_bin = sprintf("%08d", $tmp_bin);
		//convert port 2 00000010 into 01000000
		$tmp_bin = strrev($tmp_bin);		
		if ($i==0)
		{
			$sbin=$tmp_bin;
		}
		else
		{
			$sbin.=$tmp_bin;
		}
		$i+=2;
	}
	return $sbin;
}


/**
 * Convert a binary string into an hexa string, byte by byte 
 * port 3: 001000000 -> 00000100 : hexa = 04
 * @param string $hex
 * @return string
 */
private static function binarraytohex($bin)
{
	$n = strlen($bin);
	$shex="";
	$i=0;
	while($i<$n)
	{
		$tmp_bin = substr($bin,$i,8);		
		//convert 01000000 into 00000010
		$tmp_bin = strrev($tmp_bin);
		$tmp_hex = base_convert( $tmp_bin, 2, 16);
		$tmp_hex = sprintf("%02s", $tmp_hex);		
		if ($i==0)
		{
			$shex=$tmp_hex;
		}
		else
		{
			$shex.=$tmp_hex;
		}
		$i+=8;
	}
	return $shex;
}

}
?>