<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\parser\SMTOtuApi;

use app\serviceshelper\otdr\SMTOtdrFunctionDto;
use app\serviceshelper\sensing\SMTDTSFunctionDto;
use app\serviceshelper\sensing\SMTDTSSFunctionDto;
use app\sharedmemory\SMTMemoryManager;
use app\sharedmemory\SMTIMemorySupport;
use app\util\SMTDto;

class SMTModuleDto extends SMTDto implements SMTIMemorySupport
{
    /**
     * @var dtring
     */
	protected $position;
	/**
	 * @var string
	 */
	protected $type;
	/**
	 * @var string
	 */
	protected $serialNumber;
	/**
	 * @SMTAttributeInfosAnnotation(classname='app\serviceshelper\otdr\SMTOtdrFunctionDto',islist='true')
	 * @var app\serviceshelper\otdr\SMTOtdrFunctionDto[]
	 */
	protected $functions= array();

	/**
	 * @SMTAttributeInfosAnnotation(classname='app\serviceshelper\sensing\SMTDTSFunctionDto',islist='false')
	 * @var app\serviceshelper\otdr\SMTDTSFunctionDto
	 */
	protected $functionsDts= NULL;
	
	/**
	 * @SMTAttributeInfosAnnotation(classname='app\serviceshelper\sensing\SMTDTSSFunctionDto',islist='false')
	 * @var app\serviceshelper\sensing\SMTDTSSFunctionDto
	 */
	protected $functionsDtss= NULL;
	
	/**
	 * @var boolean
	 */
	protected $detected = false;

	/**
	 * @param boolean $detected
	 */
	public function setDetected( $detected )
	{
		$this->detected = $detected;
	}	
	
	/**
	 * @param string $position //MOD1,MOD2
	 */
	public function setPosition( $position )
	{
		$this->position = $position;
	}

	/**
	 * @param string $type
	 */
	public function setType( $type )
	{
		$this->type = $type;
	}

	/**
	 * @param string $serialNumber
	 */
	public function setSerialNumber( $serialNumber )
	{
		$this->serialNumber = $serialNumber;
	}
	
	/**
	 * @param SMTOtdrFunctionDto $function
	 */
	public function addFunction( SMTOtdrFunctionDto $function )
	{
	    array_push( $this->functions, $function );
	}	

	/**
	 * @param SMTDTSFunctionDto $function
	 */
	public function setDTSFunction( SMTDTSFunctionDto $function )
	{
		$this->functionsDts = $function;
	}
	
	/**
	 * @param SMTDTSSFunctionDto $function
	 */
	public function setDTSSFunction( SMTDTSSFunctionDto $function )
	{
		$this->functionsDtss = $function;
	}
		
	/**
	 * @return boolean
	 */
	public function isDetected()
	{
	    return $this->detected;
	}
	/**
	 * @return string $position //MOD1,MOD2,MOD3
	 */
	public function getPosition()
	{
		return $this->position;
	}
	
	/**
	 * @return int 1 or 2 or 3 or NULL
	 */
	public function getModuleRunningNumber()
	{
	    //WARNING mandatory for ltrim: ltrim can't evaluate the constant
	    $mod_prefix = SMTOtuApi::RES_MOD;
		return ( $this->getPosition() !== NULL )? intval( ltrim( $this->getPosition(), $mod_prefix ) ): NULL;
	}	
	
	/**
	 * @return string
	 */
	public function getType()
	{
		return $this->type;
	}

	/**
	 * @return string
	 */
	public function getSerialNumber()
	{
		return $this->serialNumber;
	}

	/**
	 * @return SMTOtdrFunctionDto[]
	 */
	public function getFunctions()
	{
		return $this->functions;
	}

	/**
	 * @return SMTDTSFunctionDto
	 */
	public function getDTSFunction()
	{
		return $this->functionsDts;
	}
	
	/**
	 * @return SMTDTSSFunctionDto[
	 */
	public function getDTSSFunction()
	{
		return $this->functionsDtss;
	}
	/**
	 * Module identifier used by memory cache: id = module position
	 *
	 * @return string
	 */
	public function getId()
	{
		return $this->getPosition();
	}
	
	/**
	 * Save Dto in shared memory
	 *
	 * @throws SMTAPCMemoryException
	 */
	public function save()
	{
		SMTMemoryManager::saveDto( $this );
	}
	
	/**
	 * Delete Dto from shared memory
	 *
	 * @throws SMTAPCMemoryException
	 */
	public function delete()
	{
		SMTMemoryManager::deleteDto( $this );
	}	
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}

	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
	
	
	/**
	 * Returns the dto class name.
	 *
	 * @return the dto class name.
	 */
	public static function getClass()
	{
		return __CLASS__;
	}

	/**
	 * Otu OTDR module cache is never obsolete: it must not be purged
	 *
	 * @return FALSE
	 */
	public function isObsolete()
	{
		return FALSE;
	}	
	
	/**
	 * No obsolescence for those data: returns current time.
	 *
	 * @see isObsolete()
	 * @return number Timestamp of the last APC memory access (used to handle obsolescence of dtos in cache)
	 */
	public function getLastAccess()
	{
		return microtime(TRUE);
	}
	
	/**
	 * No obsolescence for those data: do nothing
	 *
	 * @see isObsolete()
	 *
	 */
	public function touchAccess()
	{
	}	
}


?>