<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\security;

use app\admin\SMTOtuType;

use app\services\setup\SMTOtuCurrentPortDto;

use app\serviceshelper\monitoring\SMTLinkTest;

use app\services\monitoring\SMTCurrentPortDto;

use app\sharedmemory\SMTMemoryManager;

use app\parser\SMTOtuApi;

use app\serviceshelper\ethernet\SMTEthernet;

use app\util\SMTLogger;

use app\http\SMTHttpResponse;

use app\settings\SMTSmartOtuSettings;

use app\view\SMTTestRestApiPage;

use app\services\SMTIService;
use app\services\SMTService;

use app\admin\SMTChangeUserPasswordDto;
use app\admin\SMTLanguage;
use app\admin\SMTUserUtil;


/**
 * Login service api
 * 
 */
class SMTSecurityService extends SMTService implements SMTIService
{	
	/**
	 * 
	 * @url POST /login
	 * 
	 */
	public function login( $request_data )
	{		
	    try
	    {
	        $login = $request_data['login'];
	        $password_sha_256 = $request_data['password'];
	        $password_encoded = $request_data['smt'];
	        $language = $request_data['language'];
	        
	        SMTLanguage::setCurrentLanguage($language);
	        //test if user exists
	        $user = SMTUserUtil::authenticate( $this->getContext(), $login, $password_sha_256, $password_encoded );	 
	    }
	    catch ( \Exception $e )
	    {
	    	$this->handleException($e);
	    }	    	    		
		
		return $user->getJsonData();		
	}
	
	/**
	 *
	 * @url POST /changepassword
	 *
	 */
	public function changePassword( $request_data )
	{
		try
		{
		    $changePasswordDto = SMTChangeUserPasswordDto::getInstance( $request_data );
		    $login = $changePasswordDto->getLogin();
		    $newLogin = $changePasswordDto->getNewLogin();		    
		    $oldPassword = SMTUserUtil::decodePassword($changePasswordDto->getOldPassword());
		    $newEncodedPassword = $changePasswordDto->getNewPassword();
		    $newPassword = SMTUserUtil::decodePassword($newEncodedPassword);		    
		    
			//update user password
			SMTUserUtil::changePassword( $this->getContext(), $login, $newLogin, $oldPassword, $newPassword);
			
			//check if user exists
			$user = SMTUserUtil::authenticate( $this->getContext(), $newLogin, hash("sha256", $newPassword), $newEncodedPassword );
		}
		catch ( \Exception $e )
		{
			//$this->handleException($e); //don't trace exception: parameters are logged in log file!
		    SMTLogger::getInstance()->trace("changePassword >> Failed to change smartOTU user password with login: $login and new login $newLogin", SMTLogger::ERROR );
		    SMTHttpResponse::handleException( $e, $this->getContext() );
		}
	
		return $user->getJsonData();
	}
	
	/**
	 * @url POST /logout
	 */	
	public function logout()
	{	    	   
	    $this->getContext()->closeSession();
	    
// 	    $page = new SMTNotificationPage( SMTAction::LOG_OUT );
// 	    $this->getContext()->getHttpResponse()->send( $page );
        return self::RESULT_OK; 
	}	
	
	/**
	 * @url POST /
	 * @status 200
	 * @access protected
     * @class SMTAccessControl {@requires user}
	 */
	public function getUser()
	{
	    try
	    {
	    	//at initialisation, promote user with install_ip role if needed
	    	SMTUserUtil::chekUserRole($this->getContext());
	    	
    		$userToSend = $this->getContext()->getUser();
		}
		catch ( \Exception $e )
		{
		    $this->handleException($e);
		}
		
		return $userToSend->getJsonData();
	}	
	
	/**
	 * @url POST /init
	 * @status 200
	 * @access protected
	 * @class SMTAccessControl {@requires user}
	 */
	public function getInitApplicationData()
	{
	    $init = new SMTInitDto();
	    $dto = new SMTCurrentPortDto();
	    
	    $init->setOtuType( SMTOtuType::getOtuType() );
	    
	    try
	    {	        	        
	        //at initialisation, promote user with install_ip role if needed
	    	SMTUserUtil::chekUserRole($this->getContext());
	        
	        $init->setUser( $this->getContext()->getUser() );
	    }
	    catch ( \Exception $e )
	    {
	    	//throw exception: we are not identified
	    	$this->handleException($e);
	    }
	    
	    try
	    {
            $linkHelper = new SMTLinkTest();
    	    $linkHelper->setContext( $this->getContext() );    	        	    
    	    
    	    // virtual Switch Port Count
    	    $virtualSwitchPortCount = $linkHelper->getVirtualSwitchPortCount();

    	    if ( $virtualSwitchPortCount > 0)
    	    {
    	        $dto->setVirtualSwitchPortCount( $virtualSwitchPortCount );
    	        $currentPortOtuDto = SMTMemoryManager::fetch(SMTOtuCurrentPortDto::getClass(), SMTOtuCurrentPortDto::CURRENT_PORT_DTO_ID);
    	        if ($currentPortOtuDto != NULL)
    	        {
        	    	$dto->setCurrentPort( $currentPortOtuDto->getCurrentPort() );
        	    }    	    
    	    }
    	    
    	    $init->setCurrentPort($dto);
	    }
	    catch ( \Exception $e )
	    {
	        $init->setCurrentPort($dto);
	        //don't throw exception, either SmartOTU will not be initialized
	    	SMTLogger::getInstance()->traceException($e);
	    }
	    
	    try
	    {	    		
	    	$hostName = trim( str_replace("\"","", $this->sendReceive( SMTOtuApi::CMD_get_host_name ) ) );
	    	$init->setHostName($hostName);
	    }
	    catch(\Exception $e)
	    {
	    	$init->setHostName( gethostname() );
	    	
	    	//don't throw exception, either SmartOTU will not be initialized
	    	SMTLogger::getInstance()->traceException($e);
	    }
	    
	    try 
	    {
	    	//force local mode retrieve
	    	$socket = $this->getContext()->getOtuSocket();
	    	$localMode = SMTEthernet::isLocalMode( $socket );
	    	$init->setLocalMode($localMode);
	    }
	    catch ( \Exception $e )
	    {
	    	//don't throw exception here, either SmartOTU will not be initialized
	    	SMTLogger::getInstance()->traceException($e);
	    }
	    
	    return $init->getJsonData();
	}
	
	/**
	 * @url GET /test/user
	 */
	public function testUser()
	{
	    if ( SMTSmartOtuSettings::isDebugMode() )
	    {
    		$user = $this->getContext()->getUser();		 
    		return $user->getJsonData();
	    }
	}

	/**
	 * @url GET /test/login
	 */
	function testLogin()
	{
	    if ( SMTSmartOtuSettings::isDebugMode() )
	    {
    		$url = '/user/login';
    		$json_string = json_encode( array('login'=>'install','password'=>'install','language'=>SMTLanguage::DEFAULT_LANGUAGE) );
    		$page = new SMTTestRestApiPage( $url, $json_string, 'POST' );
    		$this->getContext()->getHttpResponse()->send( $page );
	    }
	}		
	
	/**
	 * @url GET /test/logout
	 */
	public function testlogout()
	{
	    if ( SMTSmartOtuSettings::isDebugMode() )
	    {
    		$url = '/user/logout';
    		$page = new SMTTestRestApiPage( $url, '', 'POST' );
    		$this->getContext()->getHttpResponse()->send( $page );
	    }
	}	
}


?>