<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\otdr;

use app\util\SMTDto;
use app\serviceshelper\otdr\SMTOtdrTraceType;

/**
 * Otdr acquisition DTO embedding the sor file binary buffer encoded in an Hexadecimal string.
 * 
 * @author Sylvain Desplat
 */
class SMTOtdrTraceDto extends SMTDto
{
    /**
     * OTDR file name without its path 
     * 
     * @var string
     */
    protected $otdrTraceName;
    
    /**
     * Whether the OTDR trace name is a reference trace, a new acquisition trace stored in SmartOTU directory or the last monitoring trace acquisition.
     *
     * @param string SMTOtdrTraceType::OTU_REFERENCE_TRACE, SMTOtdrTraceType::SMARTOTU_ACQUISITION_TRACE, SMTOtdrTraceType::LAST_TEST_ACQUISITION_TRACE
     */
    protected $otdrTraceType = SMTOtdrTraceType::SMARTOTU_ACQUISITION_TRACE;
    
    /**
     * OTDR binary trace buffer encoded in an hexadecimal string
     * @var string
     */
    protected $otdrTraceBuffer;     
    
    /**
     * Set OTDR file name without its path 
     * 
     * @param string $otdrTraceName
     */
    public function setOtdrTraceName( $otdrTraceName)
    {
    	$this->otdrTraceName = $otdrTraceName;
    }
    
    /**
     * get OTDR file name without its path
     *  
     * @return string
     */
    public function getOtdrTraceName()
    {        
    	return $this->otdrTraceName;
    } 
    
    /**
     * Whether the OTDR trace name is a reference trace, a new acquisition trace stored in SmartOTU directory or the last monitoring trace acquisition.
     *
     * @param string SMTOtdrTraceType::OTU_REFERENCE_TRACE, SMTOtdrTraceType::SMARTOTU_ACQUISITION_TRACE, SMTOtdrTraceType::LAST_TEST_ACQUISITION_TRACE
     */
    function setOtdrTraceType( $otdrTraceType )
    {
    	$this->otdrTraceType = $otdrTraceType;
    }
    
    /**
     * 
     * @return string SMTOtdrTraceType::OTU_REFERENCE_TRACE, SMTOtdrTraceType::SMARTOTU_ACQUISITION_TRACE, SMTOtdrTraceType::LAST_TEST_ACQUISITION_TRACE
     */
    function getOtdrTraceType()
    {
    	return $this->otdrTraceType;
    }    
    
    /**
     *
     * @param string $otdrTraceBuffer
     */
    public function setOtdrTraceBuffer( $otdrTraceBuffer )
    {
    	$this->otdrTraceBuffer = $otdrTraceBuffer;
    }
    
    /**
     *
     * @return string
     */
    public function getOtdrTraceBuffer()
    {
    	return $this->otdrTraceBuffer;
    }    
    
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json data array.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }    
}
?>