<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\services\activity;

/**
 * Activity type possible values
 * 
 * @author Sylvain Desplat
 */
class SMTActivityType
{
    /** Unknown */
    const UNKNOWN="UNKNOWN";
    const UNKNOWN_OTU_CODE="UNKNOWN";
    /** None */
    const NONE="NONE";
    const NONE_OTU_CODE="NONE";
    /** None */
    const OTDR_ON_DEMAND_MEASURE="OTDR_ON_DEMAND_MEASURE";
    const OTDR_ON_DEMAND_MEASURE_OTU_CODE="OTDR_ON_DEMAND_MEASURE";
    /** None */
    const OTDR_ON_DEMAND_TEST="OTDR_ON_DEMAND_TEST";
    const OTDR_ON_DEMAND_TEST_OTU_CODE="OTDR_ON_DEMAND_TEST";    
    /** None */
    const OTDR_MONITORING_TEST="OTDR_MONITORING_TEST";
    const OTDR_MONITORING_TEST_OTU_CODE="OTDR_MONITORING_TEST";
    /** None */
    const OTDR_PERFORMANCE_TEST="OTDR_PERFORMANCE_TEST";
    const OTDR_PERFORMANCE_TEST_OTU_CODE="OTDR_PERFORMANCE_TEST";
    /** None */
    const AUTOTEST="AUTOTEST";
    const AUTOTEST_OTU_CODE="AUTOTEST";
    
    /**
     * Whether the given string is an activity type.
     * 
     * @param string $activityType
     * @return boolean
     */
    public static function isValidActivityType( $activityType )
    {
        switch ( $activityType )
        {
        	case self::UNKNOWN:
        	case self::NONE:
        	case self::OTDR_ON_DEMAND_MEASURE:
        	case self::OTDR_ON_DEMAND_TEST:
        	case self::OTDR_MONITORING_TEST:
        	case self::OTDR_PERFORMANCE_TEST:
        	case self::AUTOTEST:
        		return TRUE;
        		break;
        	default:
        		return FALSE;
        		break;
        }
    }
    
    /**
     * Whether the given activity is a measurement
     * 
     * @param string $otuCode
     * @return boolean
     */
    public static function isMeasurementActivityOtuCode( $otuCode )
    {
        return ( self::OTDR_ON_DEMAND_MEASURE_OTU_CODE == $otuCode );
    }
    
    /**
     * Whether the given activity is a monitoring or test on demand activity
     *
     * @param string $otuCode
     * @return boolean
     */
    public static function isMonitoringOrTestOnDemandOtuCode( $otuCode )
    {
    	return ( self::OTDR_ON_DEMAND_TEST_OTU_CODE == $otuCode ||
    	         self::OTDR_PERFORMANCE_TEST_OTU_CODE == $otuCode ||
    	         self::OTDR_MONITORING_TEST_OTU_CODE == $otuCode );
    }
    
    /**
     * Whether the given activity is an autotest activity
     *
     * @param string $otuCode
     * @return boolean
     */
    public static function isAutotestActivityOtuCode( $otuCode )
    {
    	return ( self::AUTOTEST_OTU_CODE == $otuCode );
    }            
    
    /**
     * Decode otu activity type codes
     *
     * @param number $otuCode
     * @return string
     */
    public static function decodeOtuCode( $otuCode )
    {
    	switch ( $otuCode )
    	{
    		case self::UNKNOWN_OTU_CODE:
    			return self::UNKNOWN;
    			break;
    		case self::NONE_OTU_CODE:
    			return self::NONE;
    			break;
    		case self::OTDR_ON_DEMAND_MEASURE_OTU_CODE:
    			return self::OTDR_ON_DEMAND_MEASURE;
    			break;
    		case self::OTDR_ON_DEMAND_TEST_OTU_CODE:
    			return self::OTDR_ON_DEMAND_TEST;
    			break;
    		case self::OTDR_MONITORING_TEST_OTU_CODE:
    			return self::OTDR_MONITORING_TEST;
    			break;
			case self::OTDR_PERFORMANCE_TEST_OTU_CODE:
				return self::OTDR_PERFORMANCE_TEST;
				break;
			case self::AUTOTEST_OTU_CODE:
				return self::AUTOTEST;
				break;    		
			default:
				return self::UNKNOWN;
				break;						
    	}
    }
}
?>