<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\services\activity;


use app\util\SMTStatusDto;

use app\services\activity\otu\SMTOtuActivityDto;

use app\serviceshelper\activity\SMTActivity;

use app\util\SMTLogger;

use app\events\SMTEventMessageManager;
use app\services\SMTIService;
use app\services\SMTService;
use app\services\security\SMTAccessControl;


/**
 * Service to retrieve OTU activity.
 *
 * @author Sylvain Desplat
 */
class SMTActivityService extends SMTService implements SMTIService
{        
    /**
     *
     * @url POST /all
     *
     * @access protected
     * @class SMTAccessControl {@requires user}
     */
    function fetchActivity()
    {
        $activityDto = new SMTActivityDto();
        
    	try
    	{    	    	
    	    $activity_data = SMTActivity::unSerializeActivity();
    	    
    	    if ( $activity_data != FALSE )
    	    {
    	        $activityOtuDto = SMTOtuActivityDto::getInstance( $activity_data );
    	        	
    	        $activityHelper = new SMTActivity();
    	        $activityHelper->setContext( $this->getContext() );
    	        //force full retrieval of activity for next activity received
    	        $activityDto = $activityHelper->processActivity( $activityOtuDto, TRUE );
    	    }
    	}
    	catch ( \Exception $e )
    	{
    		$this->handleException($e);
    	}
    
    	return $activityDto->getJsonData();
    }
    
    /**
     *
     * @url POST /
     * @status 200
     *
     * Access granted to everybody (used by OTU application), but control on host name sending the request: only loopback address allowed.
     */
    function sendActivity( $request_data )
    {
        $result = new SMTStatusDto();
    	try
    	{
    		$request = $this->getContext()->getHttpRequest();
    		   		
//     		if (  $request->isLocalHTTPQuery() || SMTSmartOtuSettings::isDebugMode())
//     		{
    			$this->getContext()->getLogger()->trace( print_r( $request_data, true ),SMTLogger::DEBUG, __FILE__,__METHOD__,__LINE__ );
    		
    			//serialize activity in a file to be used later by new web client retrieving for the first time the activity
    			//don't save activity in APC memory to avoid to store unused data in memory
    			SMTActivity::serializeActivity( $request_data );
    			
    			if ( SMTEventMessageManager::getInstance()->hasActivityConsumersRegistered() )
    			{
        			$activityOtuDto = SMTOtuActivityDto::getInstance( $request_data );
        			$this->getContext()->getLogger()->trace( "DTO activity:".print_r( $activityOtuDto, true ), SMTLogger::DEBUG );
    			    
        			$activityHelper = new SMTActivity();
        			$activityHelper->setContext( $this->getContext() );
        			$activityDto = $activityHelper->processActivity( $activityOtuDto );
        			if ( $activityDto != NULL )
        			{        		      			    
        			    SMTEventMessageManager::getInstance()->sendActivityEvent( $activityDto );
        			}
    			}
    			$result->setStatusOK();
//     		}
//     		else
//     		{
//     			$this->getContext()->getLogger()->trace( sprintf("Remote host %s attempt to send activity: forbidden!",$request->getClientIpAddress() ), SMTLogger::ERROR, __FILE__,__METHOD__,__LINE__);
//     			throw new SMTAccessForbiddenRestException( MSG_ERROR_REMOTE_HOST_ATTEMPT_TO_SEND_ACTIVITY, "Host: ".$request->getClientIpAddress() );
//     		}
    	}
    	catch ( \Exception $e )
    	{    		
    		$result->setStatusKO();
    		$this->handleException( $e );
    	}
    
    	return $result->getJsonData();
    }    
 
}