<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\database\patch;

use app\util\SMTLogger;

use app\database\SMTSmartOtuDB;

use app\database\SMTSqlPatch;

/**
 * Datatabase patch to create the system settings table of SmartOtu
 * Database version 1
 * Patch number 2
 *
 * @author Sylvain Desplat
 */
class SMTSql01p0002 extends SMTSqlPatch
{  
//patches:
    const SQL_CREATE_SYSTEM_CONFIGURATION =
    "CREATE TABLE IF NOT EXISTS system_configuration
        (
            id INTEGER NOT NULL PRIMARY KEY,
            configuration_name TEXT NOT NULL DEFAULT \"%s\",
            timezone_sec INTEGER,
            timezone_name TEXT,
            is_timezone_dst INTEGER NOT NULL DEFAULT %d,
            smtp_server TEXT,
            smtp_login TEXT,
            smtp_password TEXT,
            is_smtp_attach_file INTEGER NOT NULL DEFAULT %d
        )";       
    
    const SQL_INSERT_DEFAULT_SYSTEM_CONFIGURATION =
    "INSERT INTO system_configuration (id) VALUES ( %d )";
    
    function __construct()
    {
        SMTLogger::getInstance()->trace( sprintf("Execute patch %s.", __CLASS__ ), SMTLogger::INFO );
        
    	//retrieve patch version
        $className = basename(__FILE__, '.php');
        preg_match_all('!\d+!', $className, $matches);
        
        $this->dbVersion = $matches[0][0];
        $this->dbPatch = $matches[0][1];    	
    }
    
    /**
     * @return SMTSql01p0002
     */    
    public static function getInstance()
    {
        return new SMTSql01p0002();
    }
    
    /**
     * Add smartOTU system_configuration table.
     *
     * @see \app\database\SMTSqlPatch::execute()
     */    
    public function execute( SMTSmartOtuDB $db )
    {
    
    	$query = sprintf( self::SQL_CREATE_SYSTEM_CONFIGURATION, "default", 0, 0 );
    	$success = $db->execWithTrace($query, SMTLogger::INFO );    
    	self::handleExecutePatchError($db, $query, $success, __FILE__, __METHOD__, __LINE__ );
    	
    	$query = sprintf( self::SQL_INSERT_DEFAULT_SYSTEM_CONFIGURATION, 0);
    	$success = $db->execWithTrace($query, SMTLogger::INFO );
    	self::handleExecutePatchError($db, $query, $success, __FILE__, __METHOD__, __LINE__ );
    	    	
	    $success = $this->addPatchTrace($db, 'Add smartOTU system_configuration table');
	    self::handleExecutePatchError($db, SMTSqlPatch::SQL_TRACE_DATABASE_PATCH, $success, __FILE__, __METHOD__, __LINE__ );    	
    }
}
?>