#!/bin/bash
#set -u
#set -x

unset LANG
unset LANGUAGE
unset LC_ALL
unset LC_CTYPE
unset LC_NUMERIC

PGNAME=`basename $0`
ACTION=$1

case $ACTION in
	"MANUFACTURER")
		FILE="ManufacturerName"
	;;
	"DEVNAME")
		FILE="DeviceName"
	;;
	"CHEMESTRY")
		FILE="DeviceChemistry"
	;;
	"SERIALNB")
		FILE="SerialNumber"
	;;
	"DATE")
		FILE="ManufactureDate"
	;;
	"CYCLECOUNT")
		FILE="CycleCount"
	;;
	"STATUS")
		FILE="Status"
	;;
	"TEMPERATURE")
		FILE="Temperature"
	;;
	"VOLTAGE")
		FILE="Voltage"
	;;
	"CHARGINGV")
		FILE="ChargingVoltage"
	;;
	"DESIGNV")
		FILE="ChargingVoltage"
	;;
	"DESIGNCAP")
		FILE="DesignCapacity"
	;;
	"REMAININGCAP")
		FILE="RemainingCapacity"
	;;
	"FULLCHARGECAP")
		FILE="FullChargeCapacity"
	;;
	"RTTE")
		FILE="RunTimeToEmpty"
	;;
	"ATTE")
		FILE="AverageTimeToEmpty"
	;;
	"ATTF")
		FILE="AverageTimeToFull"
	;;
	"TIMEALARM")
		FILE="RemainingTimeAlarm"
	;;
	"CURRENT")
		FILE="Current"
	;;
	"AVERAGECUR")
		FILE="AverageCurrent"
	;;
	"CHARGINGCUR")
		FILE="ChargingCurrent"
	;;
	"RELATIVECHARGE")
		FILE="RelativeStateOfCharge"
	;;
	"ABSOLUTECHARGE")
		FILE="AbsoluteStateOfCharge"
	;;
	"MAXERROR")
		FILE="MaxError"
	;;
	*) cat<<"EOF"
	Usage: Battery_Mngt.sh <Action>
	<Action> must be one of the following: MANUFACTURER | DEVNAME | CHEMESTRY |
	SERIALNB | DATE | CYCLECOUNT | STATUS | TEMPERATURE | 	VOLTAGE |
	CHARGINGV | DESIGNV | DESIGNCAP | REMAININGCAP | FULLCHARGECAP | RTTE |
	ATTE | ATTF | TIMEALARM | CURRENT | AVERAGECUR | CHARGINGCUR |
	RELATIVECHARGE | ABSOLUTECHARGE | MAXERROR
EOF
	exit 1
	;;
esac

if [ -e "/sys/platform/battery1/$FILE" ] ; then
	cat /sys/platform/battery1/$FILE
else
	echo "Error: Battery not present"
fi
