#!/bin/bash

ACTION=$1
USER_NAME_TO_CHANGE=(eotdr secuser utility upgeotdr sma)
BACKUP_FILE_PASSWD=/etc/password_removed
BACKUP_FILE_SHADOW=/etc/shadow_removed

if [ "$ACTION" == "DEL" ]
then
   # backup user to removed
    if [ ! -s ${BACKUP_FILE_PASSWD} ] ; then
        GREP_STR=$(echo ${USER_NAME_TO_CHANGE[@]/%/:} | tr ' ' '|')
        grep -E ${GREP_STR} /etc/passwd > ${BACKUP_FILE_PASSWD}
        grep -E ${GREP_STR} /etc/shadow > ${BACKUP_FILE_SHADOW}
    fi
    # Remove users for enhanced security
    for i in ${USER_NAME_TO_CHANGE[@]}; do
        #passwd -l ${i}
        if id ${i} > /dev/null 2>&1 ; then
            # Delete the user even if it has running process
            userdel -f ${i} > /dev/null 2>&1
        fi
    done
    exit 0
elif [ "$ACTION" == "ADD" ]
then
    # For internal use only, customers won't never do that!
    # Try to restore user as they used to be
   if [ -s ${BACKUP_FILE_PASSWD} ] ; then
        cat ${BACKUP_FILE_PASSWD} >> /etc/passwd
        cat ${BACKUP_FILE_SHADOW} >> /etc/shadow
        echo -n "" > ${BACKUP_FILE_PASSWD}
        echo -n "" > ${BACKUP_FILE_SHADOW}
   fi
   exit 0
else
      echo "Usage: "$0" ADD | DEL"
      exit 1
fi
