#!/bin/bash
#
# This script prepare OTU hardware and do :
#  - Mount SDCard partitions on hardisk and log, manage mount points
#  - Install logrotate otu special rules
#  - Disable tftp if necessary (tftp is required for eotdrv2)
#

source /etc/init.d/otu_functions

LOG_PART_RESCUE="/dev/mmcblk1p7"

is_cotu_hw
if [ $? -eq 1 ] ; then
	source /etc/otu/otuparts.sh
	# Prepare the SDCARD and mount any partition we need
	if [ -e $DEV_SDSCARD ] ; then
		mount $DEV_LOG /var/log
		mkdir -p /user/harddisk
		mount $DEV_USER /user/harddisk
	else
		echo "Err : No SDCard found, Otu will not start properly"
	fi

	# Otu use specific logrotate rules prepare them only one time
	if [ -f /etc/logrotate.d/99_otu.logrotate.otu ] ; then
		mv /etc/logrotate.d/99_otu.logrotate.otu /etc/logrotate.d/99_otu.logrotate
		mv /etc/logrotate.d/00_logsystem.logrotate.otu /etc/logrotate.d/00_logsystem.logrotate
	fi

    cat /etc/xinetd.d/inet_tftp | grep disable | grep "no" > /dev/null
    [ $? -eq 0 ] && sed -i "/disable/c\disable = yes" /etc/xinetd.d/inet_tftp
else
    cat /etc/xinetd.d/inet_tftp | grep disable | grep "yes" > /dev/null
    [ $? -eq 0 ] && sed -i "/disable/c\disable = no" /etc/xinetd.d/inet_tftp
fi
exit 0
