import QtQuick 1.1
import "Viavi_Colors.js" as VColor

Item {
    id: setupLine
    
    property alias inputText: lineName.text
    property alias inputModel: choiceLine.model
    property bool isExclusive: false
    property bool isError: false
    
    width: parent.width
    height: 60
    
    // Signals
    signal selectValueChanged( int index );
    
    // property int boxWidth: 80
    property int boxWidth: ( ( width - headerContainer.width - 4 ) - ( choiceLine.count - 1 ) * 2 ) / choiceLine.count

    Rectangle {
        id: headerContainer
        color: VColor.cViaviColorGray
        height: parent.height
        width: 150

        Text {
        	id: lineName
            anchors.fill: parent            
            color: VColor.cViaviColorWhite
            font.pixelSize: 18
            text: "N/A"
            clip: true
            wrapMode: Text.Wrap
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignHCenter
        }
        
        Image {
        	id: imagedescription
            width: 20
            height: 20
            
            visible: isError
            
            anchors.right: parent.right
            anchors.rightMargin: 3
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 3
            
            source: "/acterna/storage/look-and-feel/generic/Warning_Wizard.png"
            fillMode: Image.PreserveAspectFit
        }
    }

    Row {
        anchors.left: headerContainer.right
        anchors.leftMargin: 4

        height: parent.height

        spacing: 2

        Repeater {
            id: choiceLine
            delegate: Wizard_Setup_Message_Box_Values {
            	enabled: choiceLine.count > 1
            	width: boxWidth
            	}
        }
    }
}
