import QtQuick 1.1
import "Viavi_Colors.js" as VColor
import libfo 1.0

Rectangle {
    width: 500
    height: 400

    border.width: 2
    border.color: VColor.cViaviColorGray
    color: VColor.cViaviColorLightGray1

    property int items_margin: 10
    property int scrollbar_width: 5
    property real ratio_taille_popup_ratio: 5.0/6.0
    property int alinea_subline: title.width / 16

    // members
    property int selected_ratio_opened : -1;

    function onOKRatio(value)
    {
        if( selected_ratio_opened >= 0  )
        {
            splitters_selection.listRatio[selected_ratio_opened].ratioSelected = value;
            splitters_selection.Wizard_Item_Selection_Validate_Ratio();
            selected_ratio_opened = -1;
        }
        listSelection.btnOkClicked.disconnect(onOKRatio);
    }
    function onNOKRatio(value)
    {
        splitters_selection.Wizard_Item_Selection_Restore_Ratio();
        selected_ratio_opened = -1;
        listSelection.btnCancelClicked.disconnect(onNOKRatio);
    }

    function onOKAlarm(idx)
    {
        alarm_selection.positionList = idx;
        listSelection.btnOkClicked.disconnect(onOKAlarm);
    }
    function onNOKAlarm(idx)
    {
        listSelection.btnCancelClicked.disconnect(onNOKAlarm);
    }

    function connectToRatios(index)
    {
        selected_ratio_opened = index;
        listSelection.label = windows_manager.txtLoadRatioHeader
        listSelection.model_list = splitters_selection.listRatio[index].ratioList;
        listSelection.current_idx_selected = splitters_selection.listRatio[index].ratioSelected;
        listSelection.visible = true;
        listSelection.btnOkClicked.connect(onOKRatio);
        listSelection.btnCancelClicked.connect(onNOKRatio);
    }

    function connectToAlarms()
    {
        listSelection.label = windows_manager.txtLoadAlarmHeader
        listSelection.model_list = alarm_selection.thresholdList
        listSelection.current_idx_selected = alarm_selection.positionList;
        listSelection.visible = true;
        listSelection.btnOkClicked.connect(onOKAlarm);
        listSelection.btnCancelClicked.connect(onNOKAlarm);
    }



    Row {
        id: title
        height: 25
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.margins: items_margin
        anchors.rightMargin: 2 * items_margin

        Text {
            id: titleTxt
            width: parent.width / 2

            color: VColor.cViaviColorGray
            text: windows_manager.txtTitleSetupWindow
            font.bold: true
            font.pixelSize: 22
            horizontalAlignment: Text.AlignLeft
            verticalAlignment:  Text.AlignVCenter
        }

        Text {
            id: configTxt
            width: parent.width / 2
            color: VColor.cViaviColorGray
            text: windows_manager.txtConfigSetupWindow
            font.italic: true
            font.pixelSize: 22
            horizontalAlignment: Text.AlignRight
            verticalAlignment:  Text.AlignVCenter
        }
    }



    Flickable
    {
        id: flickableContainer
        enabled: !(keypad.visible || listSelection.visible)

        anchors.left: parent.left
        anchors.leftMargin: items_margin
        anchors.right: parent.right
        anchors.rightMargin: items_margin + indicatorFlickable.width
        anchors.top: title.bottom
        anchors.topMargin: items_margin / 2
        anchors.bottom: buttonSelection.top
        anchors.bottomMargin: items_margin
        clip: true
        boundsBehavior: Flickable.StopAtBounds
        interactive: contentHeight >  height
        
        contentHeight: lineContainer.height
        
        onContentYChanged: {
            indicatorFlickable.value = parseInt(contentY, 10) * 100 / flickableContainer.contentHeight;
        }
        
        onHeightChanged: indicatorFlickable.ratio = (indicatorFlickable.height + items_margin)  * 100 / (flickableContainer.contentHeight);
        onContentHeightChanged: indicatorFlickable.ratio = (indicatorFlickable.height + items_margin)  * 100 / (flickableContainer.contentHeight);

        contentY: parseInt(indicatorFlickable.value * flickableContainer.contentHeight / 100 , 10)

        Item {
            id: lineContainer

            height: columnContainer.height + items_margin
            width: parent.width - 2 * items_margin
            
            Column {
                id: columnContainer
                spacing: items_margin
                width: parent.width

                Wizard_Setup_Message_Box_Line {
                    id: laserChoice

                    visible: laser_selection.isVisible

                    inputText:  laser_selection.itemHeader
                    inputModel: laser_selection.itemModel
                    isExclusive: laser_selection.isExclusive
                    isError: !setup_data.isAvailable

                    onSelectValueChanged: { laser_selection.Wizard_Item_Selection_Update(index); }
                }

                Wizard_Setup_Message_Box_Line {
                    id: directionChoice

                    visible: direction_selection.isVisible

                    inputText:  direction_selection.itemHeader
                    inputModel: direction_selection.itemModel
                    isExclusive: direction_selection.isExclusive

                    onSelectValueChanged: { direction_selection.Wizard_Item_Selection_Update(index); }
                }


                Rectangle {
                    width: parent.width
                    height: splitters_selection.isRatioVisible ? 60 * 2 + items_margin : 60
                    color: VColor.cViaviColorLightGray1

                    visible: splitters_selection.isVisible

                    Wizard_Setup_Message_Box_Line {
                        id: splittersChoice
                        width: parent.width
                        inputText:  splitters_selection.itemHeader
                        inputModel: splitters_selection.itemModel
                        isExclusive: splitters_selection.isExclusive

                        onSelectValueChanged: {
                            splitters_selection.Wizard_Item_Selection_Update(index);
                        }

                    }



                    Row {
                        id: splitters_ratio
                        anchors.left: parent.left
                        anchors.right: parent.right
                        anchors.top: splittersChoice.bottom
                        anchors.topMargin: items_margin
                        spacing: items_margin
                        visible: splitters_selection.isRatioVisible

                        Rectangle {
                            id: ont
                            width: alinea_subline / 2
                            height: splitters_ratio.height
                            color: VColor.cViaviColorLightGray2
                            border.color: VColor.cViaviColorBlack
                            border.width: 1
                            anchors.verticalCenter: parent.verticalCenter
                            Text {
                                text: windows_manager.txtOLTHeader
                                font.pointSize: 14
                                color: VColor.cViaviColorWhite
                                anchors.centerIn: parent
                                rotation: -90
                                transformOrigin: Item.Center
                                verticalAlignment: Text.AlignVCenter
                                horizontalAlignment: Text.AlignHCenter
                            }

                        }
                        Repeater {
                            model: splitters_selection.listRatio
                            Wizard_Setup_Message_Box_SubLine {
                                id: subLineSplitter1
                                width:  ( splitters_ratio.width - 2 * items_margin - alinea_subline - 2 * items_margin ) / 3;
                                inputText: splitters_selection.listRatio[index].name
                                outputValue: splitters_selection.listRatio[index].ratioSelectedName
                                enableSelection: splitters_selection.listRatio[index].visible

                                onOpenEditorClicked: {
                                    connectToRatios(index);
                                }
                            }
                        }
                        Rectangle {
                            id: olt
                            width: alinea_subline / 2
                            height: splitters_ratio.height
                            color: VColor.cViaviColorLightGray2
                            border.color: VColor.cViaviColorBlack
                            border.width: 1
                            anchors.verticalCenter: parent.verticalCenter
                            Text {
                                text: windows_manager.txtONTHeader
                                font.pointSize: 14
                                color: VColor.cViaviColorWhite
                                anchors.centerIn: parent
                                rotation: 90
                                transformOrigin: Item.Center
                                verticalAlignment: Text.AlignVCenter
                                horizontalAlignment: Text.AlignHCenter
                            }
                        }
                    }
                }
                Wizard_Setup_Message_Box_Line {
                    id: distanceUnitChoice

                    visible: units_selection.isVisible

                    inputText:  units_selection.itemHeader
                    inputModel: units_selection.itemModel
                    isExclusive: units_selection.isExclusive

                    onSelectValueChanged: { units_selection.Wizard_Item_Selection_Update(index); }
                }

                Rectangle {
                    width: parent.width
                    height: 60

                    color: VColor.cViaviColorLightGray1

                    visible: launch_cable_selection.isVisible

                    Wizard_Setup_Message_Box_Line {
                        id: launchCableChoice

                        inputText:  launch_cable_selection.itemHeader
                        inputModel: launch_cable_selection.itemModel
                        isExclusive: launch_cable_selection.isExclusive

                        onSelectValueChanged: { launch_cable_selection.Wizard_Item_Selection_Update(index); }

                        boxWidth: columnContainer.width / 6 - items_margin / 2
                    }

                    Wizard_Setup_Message_Box_SubLine {
                        id: subLineLaunchCableChoice
                        width:  ( 1 * columnContainer.width / 2 -  2 * items_margin );
                        anchors.right: parent.right

                        inputText: launch_cable_selection.subLineHeader
                        outputValue: launch_cable_selection.subLineValue
                        enableSelection: launch_cable_selection.subLineIsEnabled

                        onOpenEditorClicked: {
                            keypad.visible = true;
                            keypad.titleText = launch_cable_selection.itemHeader;
                            keypad.initialText = launch_cable_selection.subLineValue;
                        }
                    }
                }

                Text {
                    text: launch_cable_selection.launchCableWarning
                    visible: launch_cable_selection.launchCableWarningDisplay
                    font.pointSize: 14
                    color: VColor.cViaviColorRed
                    anchors.horizontalCenter: parent.horizontalCenter
                    wrapMode: Text.Wrap
                }

                Rectangle {
                    width: parent.width
                    height: 60

                    color: VColor.cViaviColorLightGray1

                    visible: alarm_selection.isVisible

                    Wizard_Setup_Message_Box_Line {
                        id: alarmChoice

                        inputText:  alarm_selection.itemHeader
                        inputModel: alarm_selection.itemModel
                        isExclusive: alarm_selection.isExclusive

                        onSelectValueChanged: { alarm_selection.Wizard_Item_Selection_Update(index); }

                        boxWidth: columnContainer.width / 6 - items_margin / 2
                    }

                    Wizard_Setup_Message_Box_SubLine {
                        id: subLineAlarmChoice
                        width:  (  1 * columnContainer.width / 2 -  2 * items_margin );

                        anchors.right: parent.right

                        inputText: alarm_selection.subLineHeader
                        outputValue: alarm_selection.subLineValue
                        enableSelection: alarm_selection.subLineIsEnabled

                        onOpenEditorClicked: {
                            connectToAlarms();
                        }
                    }
                }
            }
        }

    }
    
    Slider {
        id: indicatorFlickable
        width: (visible == true) ? scrollbar_width : 0
        orientation : Qt.Vertical

        anchors.right: parent.right
        anchors.rightMargin: items_margin

        anchors.top: flickableContainer.top
        anchors.topMargin: items_margin / 2
        anchors.bottom: flickableContainer.bottom
        anchors.bottomMargin: items_margin / 2

        visible: flickableContainer.contentHeight >  flickableContainer.height

        ratio: (indicatorFlickable.height + items_margin)  * 100 / (flickableContainer.contentHeight)
    }

    Wizard_Setup_Message_Box_Button {
        id: buttonSelection
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.bottom: parent.bottom
        anchors.bottomMargin: 10

        enabled: !(keypad.visible || listSelection.visible)
    }

    Wizard_Key_Pad {
        id: keypad
        visible: false

        anchors.centerIn: parent

        minValue: launch_cable_selection.launchCableMinValue
        maxValue: launch_cable_selection.launchCableMaxValue

        onBtnOkClicked: {
            if ( initialText.length == 0 )
                initialText = 0;

            if( validationAllowed != false ) 
               launch_cable_selection.subLineValue = parseFloat(initialText);
               
            close();
        }
    }

    Wizard_Setup_Message_Box_Listview {
        id: listSelection
        width: parent.width / 2
        height: parent.height - 2 * items_margin
        visible:false
        anchors.centerIn: parent
    }
}
