import QtQuick 1.1
import "Viavi_Colors.js" as VColor
import libfo 1.0

Rectangle {
   id: container

   color: VColor.cViaviColorLightGray2
   anchors.fill: parent

   Rectangle {
        id: title_banner
        width: parent.width; height: 40
        color: "transparent"
        anchors.top : parent.top
        anchors.topMargin: 5
        Text {
            id: txtLoadMsgFile 
            width: parent.width / 2
            height: 40
            color: VColor.cViaviColorBlack
            anchors.left: parent.left
            anchors.bottom: parent.bottom
            anchors.top: parent.top
            anchors.margins: 10
            text: windows_manager.txtLoadFileHeader
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignLeft
            font.pixelSize: 20
            wrapMode: Text.Wrap
            }
         Text {
            width: parent.width / 2
            height: 40
            color: VColor.cViaviColorBlack
            anchors.right: parent.right
            anchors.bottom: parent.bottom
            anchors.top: parent.top
            anchors.margins: 10
            text: wizard_directory.pathLoaded
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignRight
            font.pixelSize: 20
            font.italic: true
            wrapMode: Text.Wrap
            }
        }

    Wizard_Load_Conf_Directory_Listview {
        id: listview
        enabled: wizard_directory.canLoad;
        anchors.margins: 10
        anchors.bottomMargin: 20
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.rightMargin: 10
        anchors.top: title_banner.bottom
        anchors.bottom: buttonSelection.top
    }

   Rectangle
   {
       id: buttonSelection
       width: nbButtons * buttonWidth + (nbButtons + 1) * buttonMargin
       height: 100
       
       property int buttonWidth: 160
       property int buttonHeight: 80
       property int textSize: 20
       property int buttonMargin: 10
       property int nbButtons: windows_manager.canAskAssist ? 2 : 1

       border.width: 3
       border.color: VColor.cViaviColorGray
       color: VColor.cViaviColorLightGray2

       anchors.horizontalCenter: parent.horizontalCenter
       anchors.bottom: parent.bottom
       anchors.bottomMargin: buttonMargin
             
       Rectangle {
           id: cancelButton
           width: buttonSelection.buttonWidth
           height: buttonSelection.buttonHeight
           radius: 5
           color: VColor.cViaviColorRed
           visible: windows_manager.canAskAssist

           anchors.bottom: buttonSelection.bottom
           anchors.left: buttonSelection.left
           anchors.margins: buttonSelection.buttonMargin
           
           Text {
               color: VColor.cViaviColorWhite
               anchors.fill: parent
               text: windows_manager.txtCancelLoadingFile
               horizontalAlignment: Text.AlignHCenter
               verticalAlignment:  Text.AlignVCenter
               font.pixelSize: buttonSelection.textSize
           }

           MouseArea {
               anchors.fill: parent
               onClicked: {
               wizard_directory.Close_Config_Load_Directory(true)
               }
           }
       }

       Rectangle {
           id: validButton
           width: buttonSelection.buttonWidth
           height: buttonSelection.buttonHeight
           color: VColor.cViaviColorGreen
           enabled: wizard_directory.canLoad;
           opacity: wizard_directory.canLoad ? 1.0 : 0.7

           anchors.bottom: buttonSelection.bottom
           anchors.right: buttonSelection.right
           anchors.margins: buttonSelection.buttonMargin
           
           visible: listview.current_idx_selected >= 0

           Text {
               color: VColor.cViaviColorWhite
               anchors.fill: parent
               text: windows_manager.txtLoadSelectedFile
               horizontalAlignment: Text.AlignHCenter
               verticalAlignment:  Text.AlignVCenter
               font.pixelSize: buttonSelection.textSize
           }

           MouseArea {
               anchors.fill: parent
               onClicked: {
	               wizard_directory.Set_Selected_Filename_From_Index(listview.current_idx_selected);
                  wizard_directory.Close_Config_Load_Directory(false)
               }
           }
       }
   }
}
