<?php
namespace app\util\upload;

require_once('SMTUpload.php');

use app\util\SMTLogger;
use app\services\maintenance\SMTUploadStatusDto;
use app\serviceshelper\maintenance\SMTUpgrade;
use app\util\upload\SMTUploadStatus;

/**
 * Begining of upload script
 * 
 */
//2 hours script timeout ( OTU release at rate 500kb/s )
set_time_limit(3600);

$upgradeDto = SMTUpgrade::getCurrentUpgrade();

$noUploadRunning = SMTUploadStatus::checkNoUploadRunning();

if ( !$upgradeDto->isUpgradeInProgressOnOtu() )
{
    $uploadStatus = upload_file( SMTUpgrade::OTU_RELEASE_CURRENT_DIR );    
}
else
{
    $uploadStatus = new SMTUploadStatusDto();
    $uploadStatus->setProgress( SMTUploadStatusDto::NO_UPLOAD );
    if ( $noUploadRunning != TRUE )
    {
        $uploadStatus->setUploadErrorStatus( SMTUploadStatusDto::UPLOAD_ALREADY_RUNNING );
        SMTLogger::getInstance()->trace("Upload already running...", SMTLogger::ERROR);
    }
    else
    {
    	$uploadStatus->setUploadErrorStatus( SMTUploadStatusDto::UPGRADE_ALREADY_RUNNING );
    	SMTLogger::getInstance()->trace("Upgrade already running...", SMTLogger::ERROR);
    }    
}

$response = buildJsonResponse( $uploadStatus );

die( $response );

?>