<?php
namespace app\util\upload;

require_once('SMTUpload.php');

use app\util\SMTLogger;
use app\services\maintenance\SMTUploadStatusDto;
use app\serviceshelper\maintenance\SMTUpgrade;
use app\util\upload\SMTUploadStatus;

/**
 * Begining of upload script
 * 
 */
//30mn script timeout
set_time_limit(1800);

$noUploadRunning = SMTUploadStatus::checkNoUploadRunning();

if ( $noUploadRunning == TRUE )
{
    $uploadStatus = upload_file( SMTUpgrade::OTU_PATCH_CURRENT_DIR );    
}
else
{
    $uploadStatus = new SMTUploadStatusDto();
    $uploadStatus->setProgress( SMTUploadStatusDto::NO_UPLOAD );
    $uploadStatus->setUploadErrorStatus( SMTUploadStatusDto::UPLOAD_ALREADY_RUNNING );
    SMTLogger::getInstance()->trace("Upload already running...", SMTLogger::ERROR);
}

$response = buildJsonResponse( $uploadStatus );

die( $response );

?>