<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI Solutions
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI Solutions
// Copyright VIAVI Solutions2018. All rights reserved.
// *********************************************************
namespace app\serviceshelper\monitoring;


/**
 * OTU peak shift mode
 * 
 * @author Sylvain Desplat
 */
class SMTPeakShiftMode
{
    /**
     * OTU peak shift with moving reference
     * @var string
     */
    const REFERENCE_TRACE = "REFERENCE_TRACE";
    
    /**
     * OTU peak shift with only tolerence for peak shift 
     * @var string
     */
    const TOLERANCE = "TOLERANCE";
    
    /**
     * OTU peak shift with moving reference
     * @var string
     */
    const OTU_REFERENCE_TRACE = "SLIDING";
    
    /**
     * OTU peak shift with only tolerence for peak shift
     * @var string
     */
    const OTU_TOLERANCE = "PEAK";
    
    /**
     * OTU peak monitoring for splitter 
     * NOT IMPLEMENTED in SMARTOTU
     * @var string
     */
    const OTU_SPLITTER = "SPLITTER";
    
    /**
     * OTU peak shift with temperature compensation
     * NOT IMPLEMENTED in SMARTOTU
     * @var string
     */
    const OTU_TEMPERATURE = "TEMPERATURE";
    
    
    /**
     * OTU default mode when there is no peak
     * @var string
     */
    const OTU_DEFAULT_MODE_WITHOUT_PEAK = self::OTU_TOLERANCE;
    
    /**
     * Get the default peak shift mode.
     *
     * @return string the default peak shift mode
     */
    public static function getDefaultPeakShiftMode()
    {
    	return self::REFERENCE_TRACE;
    }

}
?>