<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\serviceshelper\monitoring;

use app\util\SMTException;

use \app\events\operations\SMTOperationEventDto;

/**
 * Measurement exceptions
 * 
 * @author Sylvain Desplat
 *
 */
class SMTOperationException extends SMTException
{       
    /**
     * 
     * @param string $otuCode Integer encoded in a string error code used for OTU error codes
     * @param string $message 
     */
    function __construct( $code = NULL, $message = NULL )
    {
    	parent::__construct( $code, $message);
    }
    
    /**
     * Get error codes label for tracing without error codes.
     *
     * @return string
     */
    public function getErrorLabel()
    {
    	return $this->getErrorCode();
    }
    
    /**
     * Translates exception error code
     * 
     * @param string $otuCode The exception error code
     * 
     * @return string the exception message
     */
    public function decodeMessage( $otuCode )
    {
        return SMTOperationEventDto::decodeMessage($otuCode);
    }
}

?>