<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\serviceshelper\ethernet;

use app\util\SMTIOException;

use app\util\SMTLogger;

use app\parser\SMTOtuApi;
use app\serviceshelper\SMTServiceHelper;
use app\util\SMTUtil;

/**
 *
 * @author Sylvain Desplat
 */
class SMTFirewall extends SMTServiceHelper
{
    const FIREWALL_ON = "ON";
    const FIREWALL_OFF = "OFF";
    const FIREWALL_CUSTOM = "CUSTOM";
    const FIREWALL_CONFIG_FILE = "/home/secuser/firewall_ipv4_ipv6.conf.custom"; //"/acterna/user/harddisk/otu/smartOTU/.firewall.conf.custom";
    
    /**
     * Change firewal status
     *
     * @param string $firewallStatus
     */
    function setFirewallMode( $firewallStatus )
    {
    	try
    	{
    		$on = (strcasecmp($firewallStatus, self::FIREWALL_ON) == 0)? true : false;
    		$custom = (strcasecmp($firewallStatus, self::FIREWALL_CUSTOM) == 0)? true : false;
    		$this->send( SMTOtuApi::setFirewallCommand( $on, $custom ) );    		
    		SMTLogger::getInstance()->trace( sprintf("Firewall status to set: %s, %d, %d.", $firewallStatus, $on, $custom ), SMTLogger::INFO, __FILE__,__METHOD__,__LINE__);
    	}
    	catch ( \Exception $e )
    	{
    		SMTLogger::getInstance()->traceException( $e );
    	    throw $e;
    	}
    }
    
    /**
     * Get firewall status
     *
     * @return firewallMode
     */
    function getFirewallMode()
    {
    	$firewallMode = SMTFirewall::FIREWALL_OFF;
    	try
    	{
    		$firewallStatus = $this->sendReceive( SMTOtuApi::getFirewallCommand() );
    		if ( strcasecmp($firewallStatus, SMTOtuApi::FIREWALL_ON) == 0 )
    		{
    		    $firewallMode = SMTFirewall::FIREWALL_ON;
    		}
    		else if(strcasecmp($firewallStatus, SMTOtuApi::FIREWALL_CUSTOM) == 0) 
    		{
    		    $firewallMode = SMTFirewall::FIREWALL_CUSTOM;
    		}
    		else
    		{
    		    $firewallMode = SMTFirewall::FIREWALL_OFF;
    		}
    		    		
    		SMTLogger::getInstance()->trace( sprintf("Firewall status is: %s, mode is %s.", $firewallStatus, $firewallMode ), SMTLogger::INFO, __FILE__,__METHOD__,__LINE__);
    	}
    	catch ( \Exception $e )
    	{
    		SMTLogger::getInstance()->traceException( $e );
    	    throw $e;
    	}
    	return $firewallMode;
    }    
        
    /**
     * Read custom firewall config file
     * 
     * @return The custom firewall config as an array of string
     */
    function readCustomFirewallConfig()
    {
        if ( file_exists( self:: FIREWALL_CONFIG_FILE ) )
        {
            $lines = file(self::FIREWALL_CONFIG_FILE);
            SMTUtil::removeLfInArray($lines);
        }
        else
        {
		    SMTLogger::getInstance()->trace( sprintf("Failed to find: %s.", self::FIREWALL_CONFIG_FILE ), SMTLogger::ERROR, __FILE__,__METHOD__,__LINE__);
		    throw new SMTIOException(SMTIOException::FILE_NOT_FOUND, "custom firewall");
        }
        return $lines;
    }
    
    /**
     * Save the firewall config from an array of string
     * 
     * @param array
     */
    function saveConfig( $lines )
    {
    	if ( file_exists( self:: FIREWALL_CONFIG_FILE ) )
    	{
    	    $firewallFileHandle = fopen( self:: FIREWALL_CONFIG_FILE,"w");
            if ( $firewallFileHandle !== FALSE )
            {
                foreach ($lines as  $line)
                {
                    fwrite( $firewallFileHandle, $line."\n" );
                    SMTLogger::getInstance()->trace( sprintf("New firewall rule: %s.", $line ), SMTLogger::PINFO);
                }
                
                fclose( $firewallFileHandle );
            }  
    	}
    	else
    	{
		    SMTLogger::getInstance()->trace( sprintf("Failed to find: %s.", self::FIREWALL_CONFIG_FILE ), SMTLogger::ERROR, __FILE__,__METHOD__,__LINE__);
		    throw new SMTIOException(SMTIOException::FILE_NOT_FOUND, "custom firewall");    	    
    	}
    }

}
?>
