<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\services\maintenance;

use app\util\SMTRwDto;

/**
 * DTO for backup
 * 
 * @author Sylvain Desplat
 */
class SMTBackupDto extends SMTRwDto
{	
	/**
	 * backup file name
	 * 
	 * @var string
	 */
	protected $backupFileName = NULL;
	
	/**
	 * Set backup file name
	 *
	 * @param string $backupFileName
	 */
	public function setBackupFileName( $backupFileName )
	{
		$this->backupFileName = $backupFileName;
	}
	
	/**
	 * Get backup file name
	 *
	 * @return string $backupFileName
	 */
	public function getBackupFileName()
	{
		return $this->backupFileName;
	}
	
	/**
	 * Returns the dto class name.
	 *
	 * @return the dto class name.
	 */
	public static function getClass()
	{
		return __CLASS__;
	}
	
	/**
	 * Serialize as Json data (array) the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json array.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}
	
	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
	
	/**
	 * Create the Dto from a Json Dto in an array
	 *
	 * @param array $json_array json data in an array
	 *
	 * @return \app\\services\\maintenance\SMTBackupDto
	 */
	static function getInstance( array &$json_array )
	{
		return self::forge( get_class(), $json_array );
	}
}


?>