<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\alarm\otu;

use app\serviceshelper\alarm\SMTAlarmSeverity;

use app\util\SMTRwDto;





/**
 * Base alarm dto class.
 * 
 * @author Sylvain Desplat
 */
class SMTOtuOpticalAlarmAttenuationDto extends SMTRwDto
{
    /**
     * @var float
     */
    protected $distance;
    
    /**
     * @var boolean
     */
    protected $distanceValid;    
    
    /**
     * OTU severity
     * @var string
     */
    protected $severity;
    
    /**
     * Level in dB
     * 
     * @var float
     */
    protected $level;
    
    /**
     * Whether level attenuation is valid
     * @var boolean
     */
    protected $levelValid;
    
    /**
     * Specific problem code ( cOtu_Alarm_Injection )
     * 
     * @var string
     */
    protected $specific;
    /**
     * alarm longitude (decimal degree)
     *
     * @var float
     */
    protected $gpsX = 0;
    /**
     * alarm latitude (decimal degree)
     *
     * @var float
     */
    protected $gpsY = 0;
    /**
     * Whether gps coordinate is valid
     *
     * @var boolean
     */
    protected  $gpsValid = FALSE;
    
    /**
     * Whether level attenuation is valid
     * @var boolean
     */
    public function isValidLevel()
    {
        return filter_var( $this->levelValid, FILTER_VALIDATE_BOOLEAN );
    }
    
    /**
     * Whether level attenuation is valid
     * @var boolean
     */
    public function isValidDistance()
    {
        return filter_var( $this->distanceValid, FILTER_VALIDATE_BOOLEAN );        
    }
    
    /**
     * Whether alarm gps coordinates are valid
     * @var boolean
     */
    public function isValidGps()
    {
    	return filter_var( $this->gpsValid, FILTER_VALIDATE_BOOLEAN );
    }
    
    /**
     * Otu severity
     * 
     * @return string
     */
    public function getOtuSeverity()
    {
    	return $this->severity;
    }
    
    /**
     * SmartOtu Severity
     *
     * @return integer
     */
    public function getSeverityConvertedToSmartOtu()
    {
    	return SMTAlarmSeverity::fromOtuSeverityToSmartOtuSeverity( $this->severity );
    }
    
    /**
     * distance in m
     * 
     * @return float
     */
    public function getDistance()
    {
    	return $this->distance;
    }
    
    /**
     * Level in dB
     * 
     * @return float
     */
    public function getLevel()
    {
    	return $this->level;
    }    
    
    /**
     *
     * @return string
     */
    public function getSpecificProblemCode()
    {
    	return $this->specific;
    }   
    
    /**
     * Gps longitude in decimal degree
     *
     * @return float
     */
    public function getGpsX()
    {
    	return $this->gpsX;
    }
    
    /**
     * Gps latitude in decimal degree
     *
     * @return float
     */
    public function getGpsY()
    {
    	return $this->gpsY;
    }    
    
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }
    
    /**
     * Create the Dto from a Json Dto in an array
     *
     * @param array $json_array json data in an array
     *
     * @return \app\services\alarm\otu\SMTOtuOpticalAlarmAttenuationDto
     */
    static function getInstance( array &$json_array )
    {
    	return self::forge( get_class(), $json_array, FALSE );
    }
}
?>