<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services;

/**
 * Base interface for services
 * 
 * @author Sylvain Desplat
 */
interface SMTIService
{
    const SECURITY_SERVICE = "user";
    const ETHERNET_SERVICE = "ethernet";
    const MODULE_SERVICE = "module";
    const SWITCH_SERVICE = "switch";
    const EMAIL_SERVICE = "emails";
    const SMS_SERVICE = "sms";
    const SNMP_SERVICE = "snmp";
    const ONMSI_SERVICE = "server";
    const WEB_SERVICE = "ws";
    const LINK_TEST_SERVICE = "tests";
    const MESSAGE_SERVICE = "messages";
    const OTDR_ACQ_SERVICE = "acquisitions";
    const ALARM_SERVICE = "alarms";
    const SMART_OTU_SETTINGS_SERVICE = "settings";
    const ACTIVITY_SERVICE = "activity";
    const AUTOTEST_SERVICE = "autotest";
    const MAINTENANCE_SERVICE = "maintenance";
    
    /**
     * Retrieve application context in services
     * 
     * @return \app\http\SMTContext
     */
    function getContext();
    
    /**
     * Handle application exception:<br>
     *  - notify the exception to the HttpResponse object
     *
     * @param \Exception $e
     */
    function handleException( \Exception $e );    
}

?>