<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\http;

use Luracast\Restler\Format\JsonFormat;
use Luracast\Restler\Defaults;

use app\view\SMTIPage;
use app\error\SMTRestExceptionFactory;

/**
 * Http response
 * 
 * 
 * @author sdesplat
 */
class SMTHttpResponse
{	
	public function addHeader($header)
	{
		header($header);
	}
	
	public function redirectIndex($message)
	{
		$this->redirect(".");
	}
	
	
	public function redirect($location)
	{
		header('Location: '.$location);
		exit;
	}
	
    public function setCookie($name, $value = '', $expire = 0,
        $path = null, $domain = null, $secure = false, $httpOnly = true)
    {
    	setcookie($name, $value, $expire, $path, $domain,
	    $secure, $httpOnly);
    }
    
    /**
     * Send an html page or a buffer to the client. 
     * 
     * @param SMTIPage $page
     * @param boolean $sendAnExit TRUE by default 
     */
    public function send( SMTIPage $page, $sendAnExit = TRUE )
    {
        try 
        {
    		$page->generatePage();
        }
        catch ( \Exception $e )
        {
        	self::handleException($e);
        }
        if ( $sendAnExit )
        {
            exit(0);
        }        
    }
    
    /**
     * Handle exception thrown in API service and return the json error to the client.
     * 
     * @param \Exception $e
     */
    public static function handleException( \Exception $e, SMTContext $context = NULL )
    {       
        $error = SMTRestExceptionFactory::processException( $e, $context );

        $responseFormat = new JsonFormat();
        $responseFormat->setCharset(Defaults::$charset);      

        $exceptionFormated = self::formatError($error->getHttpStatus(), $error->getInternalErrorCode(), $error->getMessage() );
        
        $exceptionJson = $responseFormat->encode( $exceptionFormated, FALSE);        
        
        @header('Cache-Control: no-cache, must-revalidate', true, $error->getHttpStatus() );        
        @header('Content-Type: ' . ( $responseFormat->getMIME() ) . '; charset=' . $responseFormat->getCharset(), false );
        @header('Connection: close', false);
        die( $exceptionJson );
    }
    
    /**
     * Format error string with the following pattern:
     * 
     * @param integer $statusCode
     * @param string $internalErrorCode
     * @param string $message
     * 
     * @return array
     */
    private static function formatError($statusCode, $internalErrorCode, $message)
    {
        return array(
        		'error' => array(        		        
        				'code' => $statusCode,
        		        'internalErrorCode' => $internalErrorCode,
        				'message' => $message
        		)
        );        
    }
}

?>